require( "scripts/style.lua" );
require( "scripts/leveldescriptions.lua" );

myInstr_Image = "";
myInstr_Descr = "";
	
if ( HasInstructions(gLevel) ) then
	myInstr_Image = GetInstr_Image();
	myInstr_Descr = GetInstr_Descr();
	DebugOut("Has instructions!!");
else
	DebugOut("No instructions =(");
end

LevelInfoText = {
  standardFont,
  19,
  WhiteColor
};

TextStyle =
{
	parent = DialogBodyText,
	font = LevelInfoText,
	x = 50, y = 200, w = kMax - 100, h = kMax, flags = kVAlignCenter
};



-----------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------
MakeDialog
{
	-- Name the modal dialog
	name="LevelInfo",	
	ParkingDialog
	{
		x 		= kCenter,
		y 		= kCenter,
		w 		= kMax,
		h 		= kMax,
		fit 	= true,
		fadeSpeed	= 1.75;
		
		Bitmap
		{
			name  	= "custom_bg_image",
			image 	= "backgrounds/upgrades_background",
			x		= kCenter,
			y		= kCenter,
		},
		Bitmap
		{
			image   = myInstr_Image,
			x		= kCenter + 50,
			y		= 10+80,
		},
		
		SetStyle(TextStyle),
		Text
		{
			label = myInstr_Descr,
			x	  = kCenter,
			y     = 390,
			w	  = 480,
			h	  = 100,
			flags = kHAlignCenter + kVAlignTop,
		},
		
		SetStyle(ButtonStyle),
		Button
		{
			label	= "done",
			name	= "btndone",
			x		= kCenter,
			y		= kMax-130,
			command	= function()
						GameResumeFromDialog();
						CloseWindow(nil);
					  end;
		},
	},
}
-----------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------

GameInPauseDialog(false, false);